<?php

class FormErrorHelper {

    public $name;
    public $error;

    function FormErrorHelper($name, $error) {
        $this->name = $name;
        $this->error = $error;
    }

}

class MainController extends Controller {

    public $layout = '//layouts/column2';
    public $defaultAction = 'index';

    /**
     * @return array action filters
     */
    public function filters() {
        return array(
            'accessControl',
            array(
                'COutputCache + XajaxGetBuildingData',
                'duration' => 60,
            ),
        );
    }

    public function actions() {
        return array(
            'form' => 'application.modules.teacher.controllers.main.FormAction',
            'certificate' => 'application.controllers.actions.CertificateAction',
            'invoice' => 'application.controllers.actions.InvoiceAction',
            'bookNote' => 'application.controllers.actions.BookNoteAction',
            'ajaxInteriorHTML' => 'application.modules.student.controllers.main.InteriorAction',
        );
    }

    /**
     * Specifies the access control rules.
     * This method is used by the 'accessControl' filter.
     * @return array access control rules
     */
    public function accessRules() {
        return array(
            array('allow', // allow users to perform actions
                'actions' => array('error', 'login', 'logout', 'ajaxLogin', 'ajaxIsRegistrationEnabled',
                    'regulamin', 'ajaxRegister', 'ajaxPassword', 'ajaxIsLoggedIn',
                    'ajaxGetSchoolsByCity', 'ajaxGetClassesBySchool', 'ajaxClassRegistrationAvailable',
                    'ajaxRegisterMultipleUsers', 'ajaxInfoDialog', 'ajaxGetFirstAction', 'ajaxGetChildAction', 'ajaxInfoSubmit', 'ajaxBiuroDialog', 'passwordRecovery', 'ajaxGetDialogue',
                    'ajaxAboutDialog', 'ajaxGetBuildingData', 'ajaxGetBanksData', 'ajaxGetKontrahenciData', 'ajaxGenerateRandomPESEL', 'ajaxGenerateRandomNIP', 'ajaxGenerateRandomREGON',
		    'ajaxCalculateVat','ajaxFillZusDra','ajaxFillZusRca','ajaxPit36','ajaxPullMissedForms','ajaxGetTime'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform actions
                'actions' => array('index', 'ajaxGetCurrentLesson', 'ajaxGetAllowedInteriors', 'ajaxGetUserData', 'ajaxGetCompanyBank', 'ajaxForm', 'ajaxRemoveZalegleOplaty',
                    'ajaxFiles', 'ajaxFormTest', 'ajaxFormTestb', 'form', 'ajaxInteriorHTML', 'ajaxIsFormAccepted', 'ajaxIsFormSent', 'ajaxGetFormStatus', 'ajaxIsBlockedAction',
                    'ajaxGetSessionInfo', 'ajaxGetBusinessInfo', 'ajaxGetOfficesData', 'ajaxSaveSpecificFormData',
                    'ajaxGetNewsheadlinesData', 'certificate', 'invoice', 'ajaxAvileableWorkers',
                    'bookNote', 'ajaxGetInfoStrings','ajaxGetStudentActionData'),
                'users' => array('@'),
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionError() {
        if ($error = Yii::app()->ErrorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    public function actionLogout() {
        Yii::app()->user->logout();
        $this->redirect(Yii::app()->request->hostInfo . Yii::app()->baseUrl);
    }

    public function actionAjaxLogin() {
        $model = new UserStudentLoginForm;

        if (isset($_POST['UserStudentLoginForm']))
            {
                if(!Yii::app()->user->isGuest)
                Yii::app()->user->logout();

            $model->attributes = $_POST['UserStudentLoginForm'];

            if ($model->validate() && $model->login()) {
                $this->actionAjaxGetUserData();
				UzytkownikObecnosc::markPresenceForUsersGroup(Yii::app()->user->id);
            } else {
                echo json_encode(array_merge(array('error' => true), $model->errors));
            }
        } else
            $this->renderPartial('_loginForm', array(
                'model' => $model,
                'registrationActive' => Klasa::model()->getNumberOfRegistrationsAvailable() > 0
                    ), false, true);
    }

    public function actionAjaxIsRegistrationEnabled() {
        echo (Klasa::model()->getNumberOfRegistrationsAvailable() > 0) ? 1 : 0;
    }

    public function actionAjaxGetCurrentLesson() {
        if (Yii::app()->user->isStudent) {
            $session = UserData::getSessionInfoArray();
            echo json_encode($session);
        }
    }

    public function actionAjaxGetAllowedInteriors() {
        if (Yii::app()->user->isStudent) {
            $interiors = Akcja::getAllowedInteriors();
            $arr = array('allowedInteriors' => $interiors);
            echo json_encode($arr);
        }
    }

    public function actionAjaxGetUserData() {
        if (Yii::app()->user->isStudent) {
            $session = UserData::getSessionInfoArray();
            $firma = UserData::getBusinessInfoArray();
            $arr = array(
                'naglowki_wiadomosci' => UserData::getNewsHeadlinesJsonString(),
                'budynki' => UserData::getBuildingsJsonString(),
                'biura' => UserData::getOfficesJsonString(),
                'banki' => UserData::getBanksJsonString(),
                'imie' => Yii::app()->user->name,
                'nazwisko' => Yii::app()->user->getState('nazwisko'),
                'plec' => Yii::app()->user->getState('plec'),
                'allowedInteriors' => Akcja::getAllowedInteriors(),
                'kontrahenci' => UserData::getKontrahenciJsonString()
            );
            echo json_encode($arr + $firma + $session);
        } else {
            echo 0;
            /*
            // jesli nie zalogowany to przekierowujemy do ekranu logowania
            Yii::app()->user->logout();
            $this->redirect(Yii::app()->request->hostInfo . Yii::app()->baseUrl."/");
            */
        }
    }

    public function actionAjaxGetCompanyBank() {
        $firma = Firma::model()->find(array(
            'condition' => '"id" = :idFirmy',
            'params' => array(':idFirmy' => Yii::app()->user->getState("id_firmy")),
        ));
        if (isset($firma)) {
            echo $firma->idBanku;
        }
        else
	    echo 0;
    }

    public function actionAjaxGetSessionInfo() {
        if (Yii::app()->user->isStudent) {
            echo json_encode(UserData::getSessionInfoArray() + array(
                'imie' => Yii::app()->user->name,
                'nazwisko' => Yii::app()->user->getState('nazwisko'),
            ));
        } else
            echo 0;
    }

    public function actionAjaxGetBusinessInfo() {
        if (Yii::app()->user->isStudent)
            echo json_encode(UserData::getBusinessInfoArray());
        else
            echo 0;
    }

    public function actionAjaxGetBuildingData($mapId = 1) {
        if (Yii::app()->user->isStudent)
            echo json_encode(array(
                'budynki' => UserData::getBuildingsJsonString($mapId),
            ));
        else
            echo 0;
    }

    public function actionAjaxGetOfficesData() {
        if (Yii::app()->user->isStudent)
            echo json_encode(array(
                'biura' => UserData::getOfficesJsonString(),
            ));
        else
            echo 0;
    }

    public function actionAjaxGetBanksData() {
        if (Yii::app()->user->isStudent)
            echo json_encode(array(
                'banki' => UserData::getBanksJsonString(),
                'build' => time()
            ));
        else
            echo 0;
    }

    public function actionAjaxGetKontrahenciData() {
        if (Yii::app()->user->isStudent)
            echo json_encode(array(
                'kontrahenci' => UserData::getKontrahenciJsonString(),
                'build' => time()
            ));
        else
            echo 0;
    }

    public function actionAjaxGetNewsheadlinesData() {
        if (Yii::app()->user->isStudent)
            echo json_encode(array(
                'naglowki_wiadomosci' => UserData::getNewsHeadlinesJsonString(),
            ));
        else
            echo 0;
    }

    public function actionAjaxGetStudentActionData(){
        if (Yii::app()->user->isStudent)
            echo json_encode(array(
                'naglowki_akcji' => UserData::getStudentActionJsonString(),
            ));
        else
            echo 0;
    }



    public function actionRegulamin() {
        $message = ParametryGry::model()->findAll(array('condition' => '"nazwa" IN (\'TEXT_REJESTRACJA_REGULAMIN\')'));

        header('Content-Type: text/html; charset=utf-8');

        echo $message[0]->wartosc;
    }

    public function actionAjaxRegister() {
        $model = new UserStudentRegisterForm;
        $numberOfMaxUsers = ParametryGry::model()->find('"nazwa"=\'MAKSYMALNA_ILOSC_UCZNIOW_W_JEDNEJ_GRUPIE\'')->wartosc;
        $userModels = array();
        for ($i = 0; $i < $numberOfMaxUsers; $i++) {
            $userModels[] = new Uzytkownik('register');
        }

        $messages = ParametryGry::model()->findAll(array('condition' => '"nazwa" IN (\'TEXT_REJESTRACJA_KROK2\', \'TEXT_REJESTRACJA_KONIEC\', \'TEXT_REJESTRACJA_REGULAMIN\', \'TEXT_REJESTRACJA_REGULAMINOK\')',
            'order' => '"nazwa"'));

        $availableClasses = Klasa::model()->getClassesWithAvailableRegistration();

        if (isset($_POST['UserStudentRegisterForm'])) {
            $restrictedEmails = array();
            $restrictedPesels = array();

            $model->attributes = $_POST['UserStudentRegisterForm'];

            foreach ($userModels as $i => $userModel) {
                $userModel->attributes = $_POST['Uzytkownik'][$i + 1];
                $userModel->email = strtolower($userModel->email);
                if (!empty($userModel->email))
                    $restrictedEmails[$i + 1] = $userModel->email;
                if (!empty($userModel->pesel))
                    $restrictedPesels[$i + 1] = $userModel->pesel;
                //if(isset($_POST['validateFormId']) && !isset($_POST['register']) && $i==($_POST['validateFormId']-1))//validating only one user form
                //	break;
            }

            $modelValid = $model->validate();

            $userModelsValid = array();

            for ($i = 0; $i < $numberOfMaxUsers; $i++) {
                $userModelsValid[$i] = true;
            }

            if (isset($_POST['validateFormId']) && !isset($_POST['register'])) {//validating only one user form
                $userModels[$_POST['validateFormId'] - 1]->restrictedEmails = array_slice($restrictedEmails, 0, $_POST['validateFormId']);
                $userModels[$_POST['validateFormId'] - 1]->restrictedPesels = array_slice($restrictedPesels, 0, $_POST['validateFormId']);
                $userModelsValid[$_POST['validateFormId'] - 1] = $userModels[$_POST['validateFormId'] - 1]->validate();
            } else { //validating every not empty form
                foreach ($userModels as $i => $userModel) {
                    $userModel->restrictedEmails = $restrictedEmails;
                    $userModel->restrictedPesels = $restrictedPesels;
                }

                foreach ($userModels as $i => $userModel) {
                    if ($i == 0) {
                        $userModelsValid[$i] = $userModel->validate();
                        continue;
                    }

                    if (!$userModel->hasEmptyRegisterAttributes())
                        $userModelsValid[$i] = $userModel->validate();
                }
            }

            //saving users
            if (isset($_POST['register']) && $modelValid && !in_array(false, $userModelsValid)) {
                //creatnig temporary company
                $company = new Firma();
                $company->czasUtworzenia = new CDbExpression('SYSDATE');
                $company->nazwa = " ";
                $company->idKlasy = $model->class;
                $company->status = 0;
                $company->save(false);

                $fields = Dziedzina::model()->findAll();

                foreach ($fields as $field) {
                    $companyField = new DziedzinaFirmy();
                    $companyField->idFirmy = $company->id;
                    $companyField->idDziedziny = $field->id;
                    $companyField->punkty = 0;
                    $companyField->save(false);
                }

                foreach ($userModels as $i => $userModel) {
                    $userModel->idKlasy = $model->class;
                    $userModel->idFirmy = $company->id;
                    $userModel->register();
                }
            }

            $collectiveUserErrors = array();

            foreach ($userModels as $i => $userModel) {
                $collectiveUserErrors[] = $userModel->errors;
            }

            //returning errors
            echo json_encode(array_merge(array($model->errors), $collectiveUserErrors, array(isset($_POST['register']))));
        } else
            $this->renderPartial('_registerForm', array(
                'model' => $model,
                'cities' => Szkola::getCities(),
                'availableClasses' => $availableClasses,
                'userModels' => $userModels,
                'messages' => $messages,
                'numberOfMaxUsers' => $numberOfMaxUsers
                    ), false, true);
    }

    public function actionAjaxPassword() {
        $model = new UserStudentPasswordForm('sendEmail');

        if (isset($_POST['UserStudentPasswordForm'])) {
            $model->attributes = $_POST['UserStudentPasswordForm'];

            if ($model->validate()) {
                $model->userModel->kodDoOdzyskaniaHasla = md5(time());
                $mailMessages = ParametryGry::model()->findAll('"nazwa" IN (\'ODZYSKANIE_HASLA_UCZNIA_TEMAT_WIADOMOSCI\', \'ODZYSKANIE_HASLA_UCZNIA_TRESC_WIADOMOSCI\')', array('order' => '"nazwa"'));

                $subject = $mailMessages[0]->wartosc;
                $message = $mailMessages[1]->wartosc;

                $subject = str_replace('<imie>', $model->userModel->imie, $subject);
                $subject = str_replace('<nazwisko>', $model->userModel->nazwisko, $subject);

                $message = str_replace('<imie>', $model->userModel->imie, $message);
                $message = str_replace('<nazwisko>', $model->userModel->nazwisko, $message);
                $message = str_replace('<link>', $this->createAbsoluteUrl('passwordRecovery', array('code' => $model->userModel->kodDoOdzyskaniaHasla)), $message);

                $to = $model->userModel->email;
                $headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
                        'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
                        'X-Mailer: PHP/' . phpversion();

                mail($to, $subject, $message, $headers);

                $model->userModel->save(false);
            }
            echo json_encode($model->errors);
        } else
            $this->renderPartial('_passwordForm', array('model' => $model), false, true);
    }

    public function actionPasswordRecovery($code) {
        $user = Uzytkownik::model()->findByAttributes(array('kodDoOdzyskaniaHasla' => $code));

        if (!$user)
            throw new CHttpException(404, 'Podana strona nie istnieje.');

        $model = new UserStudentPasswordForm('setPassword');

        if (isset($_POST['UserStudentPasswordForm'])) {
            $model->attributes = $_POST['UserStudentPasswordForm'];
            if ($model->validate()) {
                $user->haslo = hash('sha1', $model->password);
                $user->kodDoOdzyskaniaHasla = '';
                $user->save(false);

                Yii::app()->user->setFlash('passwordChanged', 'Twoje hasło zostało zmienione, możesz teraz się zalogować.');
            }
        }

        $this->render('passwordRecovery', array(
            'model' => $model
        ));
    }

    public function actionAjaxGetClassesBySchool($schoolId) {
        $classes = Szkola::getClasses($schoolId);
        echo json_encode($classes);
    }

    public function actionAjaxGetCompaniesByClass($classId) {
        $companies = Klasa::getCompanies($classId);
        echo json_encode($companies);
    }

    public function actionAjaxGetSchoolsByCity($cityName) {
        $schools = Szkola::getByCity($cityName);
        echo json_encode($schools);
    }

    public function actionAjaxClassRegistrationAvailable($classId) {
        echo json_encode(array('registrationAvailable' => Klasa::registrationAvailable($classId)));
    }

    public function getFormStatus($formid) {
        $firma = Yii::app()->user->getState("id_firmy");
        $uczniowieWfirmie = Uzytkownik::model()->findAll(array(
            'condition' => '"idFirmy" = :idFirmy',
            'params' => array(
                ':idFirmy' => $firma,
            ),
        ));

        foreach ($uczniowieWfirmie as $uczen) {
            $userForm = FormularzUzytkownika::model()->find(array(
                'condition' => '"idFormularza" = :formid AND "idUzytkownika" = :userid',
                'params' => array(
                    ':formid' => $formid,
                    ':userid' => $uczen->id),
            ));
            if (isset($userForm)) {
                return $userForm->status;
            }
        }
        return false;
    }

    public function actionAjaxIsFormAccepted() {
        $formid = null;
        if (isset($_GET['formid']))
            $formid = $_GET['formid'];
        else if (isset($_POST['formid']))
            $formid = $_POST['formid'];

        if (isset($formid))
            echo ( $this->getFormStatus($formid) == FormularzUzytkownika::STATUS_ACCEPTED ) ? 1 : 0; // return
        else
            echo 0; // return false
    }

    public function actionAjaxIsFormSent() {
        $formid = null;
        if (isset($_GET['formid']))
            $formid = $_GET['formid'];
        else if (isset($_POST['formid']))
            $formid = $_POST['formid'];

        if (isset($formid))
        {
            $stat = $this->getFormStatus($formid);
            if($stat == FormularzUzytkownika::STATUS_ACCEPTED || $stat == FormularzUzytkownika::STATUS_FILLED)
            	echo 1;
            else
            	echo 0;
        }
        else
            echo 0; // return false
    }

    public function actionAjaxGetFormStatus()
    {
        $formid = null;
        if (isset($_GET['formid']))
            $formid = $_GET['formid'];
        else if (isset($_POST['formid']))
            $formid = $_POST['formid'];

        if (isset($formid))
        {
            $stat = $this->getFormStatus($formid);
            echo $stat;
        }
        else
            echo 0; // return false
    }

    public function actionAjaxForm($id, $display = true) {
        switch ($id) {
            case 1:
                $model = new Form1();
                break;
            case 2:
                $model = new Form2();
                break;
            case 3:
                $model = new Form3();
                break;
            case 4:
                $model = new Form4();
                break;
            case 5:
                $model = new Form5();
                break;
            case 6:
                $model = new Form6();
                break;
            case 7:
                $model = new Form7();
                break;
            case 8:
                $model = new Form8();
                break;
            case 9:
                $model = new Form9();
                break;
            case 10:
                $model = new Form10();
                break;
            case 11:
                $model = new Form11();
                break;
        }

        $this->layout = null;
        $model->find(Yii::app()->user->id);

        if (isset($_POST[get_class($model)])) {
            $model->attributes = $_POST[get_class($model)];

            if ($_POST['submitType'] == 'saveDraft')
                $model->status = FormularzUzytkownika::STATUS_DRAFT;
            elseif ($_POST['submitType'] == 'confirm') {
                $model->status = FormularzUzytkownika::STATUS_FILLED;
                switch ($id) {
                    case 6: // rejestracja bezrobotnego
                        $model->status = FormularzUzytkownika::STATUS_ACCEPTED;
                        break;
                }
            }

            $model->save();

            Akcja::removeSpecificAction("odrzuconyFormularz", Yii::app()->user->id);
        }

        if ($display)
            $this->renderPartial('_form' . $id, array(
                'model' => $model
                    ), false, true);
        else
            return $this->renderPartial('_form' . $id, array(
                        'model' => $model
                            ), true);
    }

    public function actionAjaxRemoveZalegleOplaty()
    {
	Akcja::removeSpecificAction("zalegleOplaty", Yii::app()->user->id);
    }

    public function actionAjaxFormTest() {
        $this->layout = null;
        $this->renderPartial('_form11_gen', array(), false, true);
    }

    public function actionAjaxFormTestb() {
        $this->layout = null;
        $model = new TestForm();
        $model->find(Yii::app()->user->id);

        if (isset($_POST['TestForm'])) {
            $model->attributes = $_POST['TestForm'];

            if ($_POST['submitType'] == 'saveDraft')
                $model->status = FormularzUzytkownika::STATUS_DRAFT;
            elseif ($_POST['submitType'] == 'confirm')
                $model->status = FormularzUzytkownika::STATUS_FILLED;

            $model->save();
        }

        $this->renderPartial('_form1_1_1', array(
            'model' => $model
        ));
    }

    public function actionAjaxInfoDialog() {
        $this->renderPartial('_infoDialog', array(), false, true);
    }

    public function actionAjaxGetFirstAction() {
        $tura = 0;
        if (isset($_POST['tura']))
            $tura = $_POST['tura'];
        else if (isset($_GET['tura']))
            $tura = $_GET['tura'];
        else {
            echo 0;
            return;
        }

        $action = Akcja::model()->find('"idRodzica" is null AND "idLekcji" = :tura', array(':tura' => $tura));

        if (isset($action))
            echo $action->id;
        else
            echo 0;
    }

    public function actionAjaxGetChildAction() {
        $lastAction = 0;
        if (isset($_POST['ostatnia_akcja']))
            $lastAction = $_POST['ostatnia_akcja'];
        else if (isset($_GET['ostatnia_akcja']))
            $lastAction = $_GET['ostatnia_akcja'];
        else {
            echo 0;
            return;
        }

        $tura = 0;
        if (isset($_POST['tura']))
            $tura = $_POST['tura'];
        else if (isset($_GET['tura']))
            $tura = $_GET['tura'];
        else {
            echo 0;
            return;
        }

	if($lastAction == 165 || $lastAction == 166 || $lastAction == 170 || $lastAction == 171 || $lastAction == 172)
	{
		// get last read action from this company with dataWykonania != null
		$newLast = AkcjaUzytkownika::model()->with('akcja')->find(array(
			'condition'=>'"t"."idFirmy" = :idFirmy AND "t"."przeczytana" = 1 AND "t"."dataWykonania" is not null AND "akcja"."czyWiadomosc" = 1 AND "akcja"."idLekcji" = :tura',
			'order'=>'"t"."id" DESC',
			'params' => array(':idFirmy'=>Yii::app()->user->getState('id_firmy'),
					  ':tura'=>$tura),
		));
		if(isset($newLast))
			$lastAction = $newLast->idAkcji;
	}

        // załaduj kolejną akcję jeśli występuje jakaś z idRodzica = ostatnia_akcja i ma ustawione pole czyAutomatyczna!=0 i czyObowiazkowa!=0
        // jeśli kolejna też została wykonana przez użytkownika to szukamy dalej niewykonanych automatycznych akcji aż do końca tej lekcji
        // TIP: Akcja z ustawionym czyAutomatyczna na true to taka akcja, która wykonuje się kolejno po zatwierdzeniu poprzedniej


        $actions = Akcja::model()->findAll(array('condition' => '"idLekcji" = :idLekcji AND "czyAutomatyczna" > 0 AND "czyObowiazkowa" > 0',
            'order' => '"id" ASC',
            'params' => array(':idLekcji' => $tura)
        ));

        // check if already done
        $userActions = AkcjaUzytkownika::model()->findAll(array('condition' => '"idFirmy" = :idFirmy',
            'order' => '"idAkcji" ASC',
            'params' => array(':idFirmy' => Yii::app()->user->getState('id_firmy'))
        ));

        $countRead = 0;
        $canShow = true;
        $nextActionId = 0;

        foreach ($userActions as $uact) {
            foreach ($actions as $act) {
                // znalezlismy akcje dziedziczaca po ostatniej
                if ($act->idRodzica == $lastAction) {
                    // sprawdzmy czy nie zostala jeszcze wykonana
                    if ($uact->idAkcji == $act->id) {
                        // Jeśli akcja automatyczna ma ustawione czyWiadomosc = 0 i czyObowiazkowa>0 to
                        // pokazujemy ją nawet jeśli była już pokazywana w tej lekcji.
                        if ($act->czyWiadomosc <= 0 && $act->czyObowiazkowa > 0) {
                            $canShow = true;
                            $nextActionId = $act->id;
                            break 2;
                        } else {
                            $countRead ++;
                            $canShow = false;
                            $lastAction = $uact->idAkcji;
                        }
                    } else {
                        $nextActionId = $act->id;
                        $canShow=true;
                        break; // 2;
                    }
                }
            }
        }

        // jesli nie znaleziono nextActionId musimy jeszcze szukac kolejnych obowiazkowych
        // akcji dla tej lekcji, bo moglismy kilka wykonac a reszte pominac
        /*
          if(!$canShow && $countRead < count($actions)-1)
          {
          $canShow = true;
          $nextActionId = $actions[$countRead+1]->id;
          }
         */

        // jesli do tej pory nie ma wiecej automatycznych akcji to szukamy kolejnej obowiazkowej nieautomatycznej,
        // która nie jest bezposrednim dzieckiem poczatka lekcji (czyli informujemy gracza, który
        // zamknął przeglądarkę w trakcie lekcji które zadanie ma teraz zrobić).
        if (!$canShow) {

        }

        if ($canShow)
            echo $nextActionId;
        else
            echo 0;
    }

    public function actionAjaxIsBlockedAction() {
        if (Yii::app()->user->isStudent) {
            echo Akcja::isBlockedAction(Yii::app()->user->id);   //? 1 : 0 ;
        }
    }

    public function actionAjaxPullMissedForms() {
    	if(Yii::app()->user->isStudent)
    	{
    	    $nrlekcji = 0;
    	    if (isset($_POST['lessonNo']))
    		$nrlekcji = $_POST['lessonNo'];
    	    else if (isset($_GET['lessonNo']))
        	$nrlekcji = $_GET['lessonNo'];
    	    else
    	    {
    	    	return;
    	    }

    	    if($nrlekcji<=0)
    	    {
    	      return;
    	    }
    	    else
    	    {
    		  Akcja::pullMissedForms($nrlekcji);
    	    }
    	}
    }

    public function actionAjaxInfoSubmit() {
        if (Yii::app()->user->isStudent) {
            $aktualnaAkcja = 0;
            if (isset($_POST['akcja']))
                $aktualnaAkcja = $_POST['akcja'];
            else if (isset($_GET['akcja']))
                $aktualnaAkcja = $_GET['akcja'];
            else
                return;

            if ($aktualnaAkcja <= 0) {
                echo 0;
                return;
            }

            $tura = 0;
            if (isset($_POST['tura']))
                $tura = $_POST['tura'];
            else if (isset($_GET['tura']))
                $tura = $_GET['tura'];
            else
                return;

            $read = true;
            if (isset($_POST['przeczytana']))
                $read = $_POST['przeczytana'];
            else if (isset($_GET['przeczytana']))
                $read = $_GET['przeczytana'];

            // pobierz wszystkie akcje dla -/tej- wszystkich lekcji
            $actions = Akcja::model()->findAll(array(//'condition' => '"idLekcji" = :idLekcji',
                'index' => 'id',
                'order' => '"id" ASC',
                //'params' => array(':idLekcji' => $tura)
            ));

            // pobierz wszystkie akcje wykonane przez ta firme
            $userActions = AkcjaUzytkownika::model()->findAll(array('condition' => '"idFirmy" = :idFirmy',
                'order' => '"idAkcji" ASC',
                'params' => array(':idFirmy' => Yii::app()->user->getState('id_firmy'))
            ));

            $canSave = true;

            foreach ($userActions as $uact) {
                if ($uact->idAkcji == $aktualnaAkcja) {
                    if ($read) // && empty($actions[$aktualnaAkcja]->przeczytana)) {
                    {
						$uact->przeczytana = 1;
						$uact->dataWykonania = new CDbExpression('SYSDATE');
						$uact->save(false,array("id","idAkcji","idUzytkownika","dataWykonania","naglowek","idFirmy","dataWyslania","przeczytana"));
						//echo 1;

						echo json_encode(array(
							'naglowek' => $uact->naglowek,
							'tresc' => $uact->tresc,
						));

						return;
                    }
					else
					{
						$automatyczneWykonywanie = array(4,5,8,9,10,14,16,17,50,52,53,170,171,172);

						if(in_array($uact->idAkcji, $automatyczneWykonywanie))
							$canSave = true;
						else
						{
							$canSave = false;
							echo 0;
							return;
						}
                    }
                }
            }

            if($canSave)
			{
                $akcjaDoDodania = $actions[$aktualnaAkcja]->generate(Yii::app()->user, $read);

                if(!empty($akcjaDoDodania))
                    $akcjaDoDodania->save(false);

				echo json_encode(array(
					'naglowek' => $akcjaDoDodania->naglowek,
					'tresc' => $akcjaDoDodania->tresc,
				));

                return;
            }
        }

        echo 0;
    }

    public function actionAjaxSaveSpecificFormData() {
        $cname = null;
        if (isset($_POST['companyName']))
            $cname = $_POST['companyName'];
        else if (isset($_GET['companyName']))
            $cname = $_GET['companyName'];
        if (!$cname)
            $cname = " ";

        $cnip = null;
        if (isset($_POST['companyNIP']))
            $cnip = intval($_POST['companyNIP']);
        else if (isset($_GET['companyNIP']))
            $cnip = intval($_GET['companyNIP']);

        $cregon = null;
        if (isset($_POST['companyREGON']))
            $cregon = intval($_POST['companyREGON']);
        else if (isset($_GET['companyREGON']))
            $cregon = intval($_GET['companyREGON']);

        $cpesel = null;
        if (isset($_POST['userPESEL']))
            $cpesel = $_POST['userPESEL'];
        else if (isset($_GET['userPESEL']))
            $cpesel = $_GET['userPESEL'];

        $cdziedzina = null;
        if (isset($_POST['dziedzina']))
            $cdziedzina = $_POST['dziedzina'];
        else if (isset($_GET['dziedzina']))
            $cdziedzina = $_GET['dziedzina'];

        $uzytkownik = Uzytkownik::model()->find(array(
            'condition' => '"id" = :user_id',
            'params' => array(':user_id' => Yii::app()->user->id),
        ));

//	CVarDumper::dump($_GET);
//	echo $cname.'<br/>'.$cnip.'<br/>'.$cregon.'<br/>'.$cpesel.'<br/>'.$cdziedzina.'<br/>';


        if (isset($cpesel))
            $uzytkownik->pesel = $cpesel;
        $firma = $uzytkownik->firma;
        if (isset($cnip))
            $firma->nip = $cnip;
        if (isset($cname))
            $firma->nazwa = $cname;
        if (isset($cregon))
            $firma->regon = $cregon;
        if (isset($cdziedzina))
            $firma->idDziedziny = $cdziedzina;
        $uzytkownik->save(false);
        $firma->save(false);
    }

    public function actionAjaxBiuroDialog() {
        if (isset($_POST['budynekId']))
            $bid = intval($_POST['budynekId']);
        else if (isset($_GET['budynekId']))
            $bid = intval($_GET['budynekId']);
        else
            return;

        $messages = array();
        $budynekModel = Budynek::model()->find(array('condition' => '"id" = :idBud',
            'params' => array(':idBud' => $bid)));
        $biuroModel = Biuro::model()->find(array('condition' => '"idBudynku" = :idB',
            'params' => array(':idB' => $bid)));
        //$firma = BiuroFirmy::model()->find(array(
        $firma = BiuroFirmy::model()->with('firma')->find(array(
            'condition' => '"t"."idBiura" = :idBiura and "t"."czasRezygnacji" is null and "firma"."idKlasy" = :id_klasy',
            'params' => array(':idBiura' => $biuroModel->id,
            		      ':id_klasy' => Yii::app()->user->getState('id_klasy')),
        ));
        $firmaModel = Firma::model()->find('"id" = :id_firmy', array(':id_firmy' => Yii::app()->user->getState('id_firmy')));
        $ileMamBiur = count(BiuroFirmy::model()->findAll(array('condition' => '"idFirmy" = :idFirmy',
                    'params' => array(':idFirmy' => Yii::app()->user->getState('id_firmy')))));

        $isBooked = true;
        if (( isset($_POST['buyBiuro']) || isset($_GET['buyBiuro']) ) && !$firma) {
            if ($ileMamBiur <= 0) {
                if (intval($firmaModel["stanKonta"]) >= intval($biuroModel["cenaWynajem"]) + intval($biuroModel["cenaMedia"])) {
                    $biuro = new BiuroFirmy();
                    $biuro->idFirmy = Yii::app()->user->getState('id_firmy');
                    $biuro->idBiura = $biuroModel["id"];
                    $biuro->czasWynajmu = date('d-m-Y H:i:s');
                    if ($biuro->save()) {
                        $messages[0] = "Biuro wynajete!";
                        $messages[1] = "Udało ci się wynająć biuro. Miesięczne opłaty:<br/>"
                                . "<br/>- wynajem: " . $biuroModel["cenaWynajem"]." zł"
                                . "<br/>- media: " . $biuroModel["cenaMedia"]." zł"
                                . "<br/>Pamiętaj o regularnych opłatach!";
                                Akcja::removeSpecificAction("zalegleBiuro", Yii::app()->user->id);
                    } else {
                        $messages[0] = "Wystąpił problem!";
                        $messages[1] = "Wystąpił problem!";
                    }
                } else {
                    $messages[0] = "Brak wystarczających środków!";
                    $messages[1] = "Nie posiadasz wystarczającej ilości środków by wynająć ten lokal!";
                }
            } else {
                $messages[0] = StringUtils::c("[Wynajełaś/Wynająłeś] już jedno biuro!");
                $messages[1] = "Nie możesz wynająć dwóch biur na tym etapie gry!";
            }
            $this->renderPartial('_biuroDialog', array('messages' => $messages, 'isBooked' => $isBooked), false, true);
        } elseif (isset($_POST['sellBiuro'])) {
            $isBooked = true;
            if ($firma->idFirmy != Yii::app()->user->id_firmy) {
                $messages[0] = "Nie możesz zrezygnować z biura";
                $messages[1] = "To biuro nie jest wynajęte przez twoją firmę.";
            } else if (Firma::getFreeSpace(Yii::app()->user->id_firmy) >= (int) $biuroModel->maxPracownikow) {
                $firma->czasRezygnacji = date('d-m-Y H:i:s');
                $firma->save();
                $messages[0] = StringUtils::c("[Zrezygnowałaś/Zrezygnowałeś] z biura!");
                $messages[1] = "Umowa z najemcą została pomyślnie anulowana!";
            } else {
                $messages[0] = "Nie możesz zrezygnować z biura";
                $messages[1] = "Nie można zrezygnować z biura ponieważ pracownicy nie będą mieli przestrzeni do pracy.";
            }

            $this->renderPartial('_biuroDialog', array('messages' => $messages, 'isBooked' => $isBooked), false, true);
        } else {
            if (!empty($firma) && $firma->idFirmy == Yii::app()->user->id_firmy) {
                $isBooked = false;
                $messages[0] = "Czy chcesz zrezygnować z lokalu?";
                $messages[1] = "Lokalizacja: " . $budynekModel["adres"]
                        . "<br/>Powierzchnia: " . $biuroModel["powierzchnia"]." m<sup>2</sup>"
                        . "<br/>Opłata za wynajem: " . $biuroModel["cenaWynajem"]." zł"
                        . "<br/>Opłata za media: " . $biuroModel["cenaMedia"]." zł";
            } else if (!$firma) {
                $isBooked = false;
                if (intval($firmaModel["stanKonta"]) >= intval($biuroModel["cenaWynajem"]) + intval($biuroModel["cenaMedia"])) {
                    $messages[0] = "Czy chcesz wynająć to biuro?";
                    $messages[1] = "Lokalizacja: " . $budynekModel["adres"]
                            . "<br/>Powierzchnia: " . $biuroModel["powierzchnia"]." m<sup>2</sup>"
                            . "<br/>Opłata za wynajem: " . $biuroModel["cenaWynajem"]." zł"
                            . "<br/>Opłata za media: " . $biuroModel["cenaMedia"]." zł";
                } else {
                    $isBooked = true;
                    $messages[0] = "Brak wystarczających środków!";
                    $messages[1] = "Nie posiadasz wystarczającej ilości środków by wynająć ten lokal!";
                }
            } else {
                $firmaWlasciciel = Firma::model()->find('"id" = :id_firmy', array(':id_firmy' => intval($firma["idFirmy"])));
                $isBooked = true;
                $messages[0] = "Nie można wynająć!";
                $messages[1] = "To biuro jest już wynajęte przez firmę: " . $firmaWlasciciel["nazwa"];
            }

            $this->renderPartial('_biuroDialog', array('messages' => $messages, 'isBooked' => $isBooked), false, true);
        }
    }

    public function actionAjaxIsLoggedIn() {
        if (Yii::app()->user->isStudent)
            echo 1;
        else
            echo 0;
    }

    public function actionAjaxGetDialogue($hash) {
        $conversation = Dialog::model()->getDialogue($hash);

        echo json_encode($conversation);
    }

    public function actionAjaxAboutDialog() {
        $this->renderPartial('_about', array(), false, true);
    }

    public function actionAjaxAvileableWorkers() {
        header('Content-type: text/json');
        $idDziedziny = filter_input(INPUT_GET, 'idDziedziny', FILTER_VALIDATE_INT);
        $idAgencji = filter_input(INPUT_GET, 'idAgencji', FILTER_VALIDATE_INT);
        echo json_encode(Pracownik::getAvileableWorkers($idDziedziny, $idAgencji));
    }

    public function actionAjaxGenerateRandomPESEL() {
        $res = Uzytkownik::model()->find('"id" = :id_uzytkownika', array(':id_uzytkownika' => Yii::app()->user->id));

            //if (strlen($res->pesel) == 11)
            //if (false)
        if (isset($res->pesel))
            echo $res->pesel;
        else {

            $wynik = '';
            for ($i = 0; $i < 11; $i++) {
                $zm1 = rand(0, 9);
                $zm1 = (string) $zm1;
                $wynik = $wynik . $zm1;
            }
            echo $wynik;
        }
    }

    public function actionAjaxGenerateRandomNIP() {
        $res = Firma::model()->find('"id" = :id_firmy', array(':id_firmy' => Yii::app()->user->getState('idFirmy')));
        if (isset($res->nip))
            echo $res->nip;
        else {
            $wynik = '';
            for ($i = 0; $i < 10; $i++) {
                $zm1 = rand(0, 9);
                $zm1 = (string) $zm1;
                $wynik = $wynik . $zm1;
            }
            echo $wynik;
        }
    }

    public function actionAjaxGenerateRandomREGON() {
        $res = Firma::model()->find('"id" = :id_firmy', array(':id_firmy' => Yii::app()->user->getState('idFirmy')));
        if (isset($res->regon))
            echo $res->regon;
        else {
            $wynik = '';
            for ($i = 0; $i < 9; $i++) {
                $zm1 = rand(0, 9);
                $zm1 = (string) $zm1;
                $wynik = $wynik . $zm1;
            }
            echo $wynik;
        }
    }

	public function actionAjaxCalculateVat()
	{
		$tura = 0;
        	if (isset($_POST['tura']))
            	    $tura = $_POST['tura'];
        	else if (isset($_GET['tura']))
            	    $tura = $_GET['tura'];
        	else {
            	    echo 0;
            	    return;
        	}
		$idFirmy = Yii::app()->user->getState("id_firmy");
		$idKlasy = Yii::app()->user->getState('id_klasy');

		if($tura >= 7 && $tura < 11)
		{
				$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 1 AND "idKlasy" = '.$idKlasy)->queryScalar();
				$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 7 AND "idKlasy" = '.$idKlasy)->queryScalar();
		}
		else if($tura >= 11 && $tura < 15)
		{
				$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 7 AND "idKlasy" = '.$idKlasy)->queryScalar();
				$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 11 AND "idKlasy" = '.$idKlasy)->queryScalar();
		}
		else if($tura >= 15)
		{
				$dateStart = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 11 AND "idKlasy" = '.$idKlasy)->queryScalar();
				$dateStop = Yii::app()->db->createCommand('SELECT "czasRozpoczecia" FROM "Tura" WHERE "idLekcji" = 15 AND "idKlasy" = '.$idKlasy)->queryScalar();
		}

		$podstawa = (float)Yii::app()->db->createCommand('
				select
				sum(round(case when f."czyKoszt" > 0 then -1 else 1 end * f."cenaNetto", 2)) "x"
				from "Faktury" f
				where f."idFirmy" = :companyId
				and f."dataWystawienia" >
				to_date(\''.$dateStart.'\', \'dd-mm-yyyy hh24:mi:ss\')
				and f."dataWystawienia" <
				to_date(\''.$dateStop.'\', \'dd-mm-yyyy hh24:mi:ss\')
		')->queryScalar(array(':companyId' => $idFirmy));

		$vat = (float)Yii::app()->db->createCommand('select (select
						sum(round(case when f."czyKoszt" > 0 then -1 else 1 end * f."stawkaVat" * f."cenaNetto", 2)) "x"
				from "Faktury" f
				where f."idFirmy" = :companyId and f."dataWystawienia" > to_date(\''.$dateStart.'\', \'dd-mm-yyyy hh24:mi:ss\') and f."dataWystawienia" < to_date(\''.$dateStop.'\', \'dd-mm-yyyy hh24:mi:ss\')
		) + (
				select nvl(round(sum(o."wartosc"),2), 0) from "Oplaty" o
				where o."idFirmy" = :companyId and o."rodzajOplaty" = 6 and o."wartosc" < 0
		) "vat" from dual')->queryScalar(array(':companyId' => $idFirmy));

		$returns = array();
		$returns['suma'] = number_format($podstawa,2,".","");
		$returns['podatek'] = number_format($vat,2,".","");

		echo json_encode($returns);
		// return $returns;
	}

	public function actionAjaxFillZusDra()
	{
                $tura = 0;
                if (isset($_POST['tura']))
                    $tura = $_POST['tura'];
                else if (isset($_GET['tura']))
                    $tura = $_GET['tura'];
                else {
                    echo 0;
                    return;
                }
                $idFirmy = Yii::app()->user->getState("id_firmy");
                $idKlasy = Yii::app()->user->getState('id_klasy');

		$returns = array();
		// inicjalizacja pustych 40 elementow
		for($i=0;$i<40;$i++) $returns[$i] = null;

		// czy sa pracownicy (termin 1 - samemu, 3 - z pracownikami)
		$workers = PracownikFirmy::model()->findAll(array(
			'condition'=>'"idFirmy" = :idfirmy',
			'params'=>array(':idfirmy'=>$idFirmy)
		));

		if(empty($workers) || count($workers)<1)
			$returns[1] = "1";
		else
			$returns[1] = "3";

		$returns[2] = "01";
		$returns[3] = date("m");
		$returns[4] = date("Y");

		// czy byly placone ZUSy w zeszlym miesiacu (numer deklaracji)

		// dane firmy
		$firma = Firma::model()->find(array(
			'condition'=>'"id" = :idfirmy',
			'params'=>array(':idfirmy'=>$idFirmy)
		));

		$returns[8] = $firma->nazwa;
		$returns[9] = Yii::app()->user->getState('nazwisko');
		$returns[10] = Yii::app()->user->getState('imie');

		// liczba pracownikow + przedsiebiorca
		if(empty($workers) || count($workers)<1)
			$returns[15] = "1";
		else
			$returns[15] = (string)(1+count($workers));

		// stopa procentowa wypadkowe
		$returns[14] = number_format(ParametryGry::getFloat('ZUS_WYP_PRACODAWCA_PROC', 1.93),2,",","");

		// skladki pracownikow i pracodawcy
		$pensjaMinimalna     = ParametryGry::getFloat('PENSJA_MINIMALNA', 1680.00);
                $emeryturaPracodawca = ParametryGry::getFloat('ZUS_EMER_PRACODAWCA_PROC', 9.76);
                $emeryturaPracownik  = ParametryGry::getFloat('ZUS_EMER_PRACOWNIK_PROC', 9.76);
                $rentaPracodawca     = ParametryGry::getFloat('ZUS_RENT_PRACODAWCA_PROC', 6.50);
                $rentaPracownik      = ParametryGry::getFloat('ZUS_RENT_PRACOWNIK_PROC', 1.50);
                $wypadkowePracodawca = ParametryGry::getFloat('ZUS_WYP_PRACODAWCA_PROC', 1.93);
                $chorobowePracownik  = ParametryGry::getFloat('ZUS_CHOR_PRACOWNIK_PROC', 2.45);
                $zdrowotnePracownik  = ParametryGry::getFloat('ZUS_ZDROW_PRACOWNIK_PROC', 9.00);
                $funduszPracodawca   = ParametryGry::getFloat('ZUS_FP_PRACODAWCA_PROC', 2.45);
                $kosztUzyskPrzychodu = ParametryGry::getFloat('ZUS_KOSZT_UZYSKANIA_PRZYCHODU', 111.25);

		// -- emerytalna ubezpieczony
		$emeryt_ubezp = ParametryGry::getFloat('ZUS_EMERYT_PRZEDSIEBIORCY', 98.38);
		foreach($workers as $worker)
			$emeryt_ubezp += $worker->wynagrodzenie*($emeryturaPracownik/100.0);
		$returns[19] = number_format($emeryt_ubezp,2,",","");

		// -- emerytalna platnik
		$emeryt_platnik = 0;
		foreach($workers as $worker)
			$emeryt_platnik += $worker->wynagrodzenie*($emeryturaPracodawca/100.0);
		$returns[24] = number_format($emeryt_platnik,2,",","");

		// -- renta ubezpieczony
		$renta_ubezp = ParametryGry::getFloat('ZUS_RENTOW_PRZEDSIEBIORCY', 40.32);
		foreach($workers as $worker)
			$renta_ubezp += $worker->wynagrodzenie*($rentaPracownik/100.0);
		$returns[20] = number_format($renta_ubezp,2,",","");

		// -- renta platnik
		$renta_platnik = 0;
		foreach($workers as $worker)
			$renta_platnik += $worker->wynagrodzenie*($rentaPracodawca/100.0);
		$returns[23] = number_format($renta_platnik,2,",","");

		// suma ubezpieczony
		$returns[21] = number_format($emeryt_ubezp+$renta_ubezp,2,",","");
		// suma platnik
		$returns[22] = number_format($emeryt_platnik+$renta_platnik,2,",","");
		// suma emerytalne
		$returns[16] = number_format($emeryt_ubezp+$emeryt_platnik,2,",","");
		// suma rentowe
		$returns[17] = number_format($renta_ubezp+$renta_platnik,2,",","");
		// suma em+re
		$returns[18] = number_format($emeryt_platnik+$renta_platnik+$emeryt_ubezp+$renta_ubezp,2,",","");

		// chorobowe ubezpieczony
		$chorob_ubezp = ParametryGry::getFloat('ZUS_CHOROB_PRZEDSIEBIORCY', 12.35);
		foreach($workers as $worker)
                        $chorob_ubezp += $worker->wynagrodzenie*($chorobowePracownik/100.0);
		$returns[28] = number_format($chorob_ubezp,2,",","");

		// wypadkowe ubezpieczony
		$wypadk_ubezp = ParametryGry::getFloat('ZUS_WYPADK_PRZEDSIEBIORCY', 9.73);
		$returns[29] = number_format($wypadk_ubezp,2,",","");

		// wypadkowe platnik
		$wypadk_platnik = 0;
		foreach($workers as $worker)
			$wypadk_platnik += $worker->wynagrodzenie*($wypadkowePracodawca/100.0);
		$returns[32] = number_format($wypadk_platnik,2,",","");

		// suma ubezpieczony 2
		$returns[30] = number_format($chorob_ubezp+$wypadk_ubezp,2,",","");
		// suma platnik 2
		$returns[31] = number_format($wypadk_platnik,2,",","");
		// suma chorobowe
		$returns[25] = number_format($chorob_ubezp,2,",","");
		// suma wypadkowe
		$returns[26] = number_format($wypadk_ubezp+$wypadk_platnik,2,",","");
		// suma chorwyp
		$returns[27] = number_format($chorob_ubezp+$wypadk_ubezp+$wypadk_platnik,2,",","");

		// suma spoleczne
		$suma_spoleczne = $emeryt_platnik+$renta_platnik+$emeryt_ubezp+$renta_ubezp+$chorob_ubezp+$wypadk_ubezp+$wypadk_platnik;
		$returns[33] = number_format($suma_spoleczne,2,",","");
		$returns[34] = number_format($suma_spoleczne,2,",","");

		// zdrowotne
		$zdrowotne = ParametryGry::getFloat('ZUS_UZ_PRZEDSIEBIORCY', 270.40);
		foreach($workers as $worker)
		{
			$spoleczne_pracownika = $worker->wynagrodzenie*($emeryturaPracownik/100.0) + $worker->wynagrodzenie*($rentaPracownik/100.0) + $worker->wynagrodzenie*($chorobowePracownik/100.0);
			$zdrowotne += ($worker->wynagrodzenie-$spoleczne_pracownika)*($zdrowotnePracownik/100.0);
		}
		$returns[35] = number_format($zdrowotne,2,",","");
		$returns[36] = number_format($zdrowotne,2,",","");

		// FGSP
		$fgsp = ParametryGry::getFloat('ZUS_PODSTAWA_US_PRZEDSIEBIORCY', 504.00)*(ParametryGry::getFloat('ZUS_FGSP_PROC', 0.10)/100.0);
		foreach($workers as $worker)
			$fgsp += $worker->wynagrodzenie*($funduszPracodawca/100.0);
		$returns[38] = number_format($fgsp,2,",","");
		$returns[37] = number_format($fgsp,2,",","");

		// pozostałe pola
		$returns[39] = date('dmY');

		echo json_encode($returns);
	}

	public function actionAjaxFillZusRca()
	{
                $tura = 0;
                if (isset($_POST['tura']))
                    $tura = $_POST['tura'];
                else if (isset($_GET['tura']))
                    $tura = $_GET['tura'];
                else {
                    echo 0;
                    return;
                }
                $idFirmy = Yii::app()->user->getState("id_firmy");
                $idKlasy = Yii::app()->user->getState('id_klasy');
		$returns = array();

		// inicjalizacja pustych 40 elementow
		for($i=0;$i<88;$i++) $returns[$i] = null;

		$returns[1] = "01";
		$returns[2] = date("mY");

		// dane firmy
		$firma = Firma::model()->find(array(
			'condition'=>'"id" = :idfirmy',
			'params'=>array(':idfirmy'=>$idFirmy)
		));

		$returns[6] = $firma->nazwa;
		$returns[7] = Yii::app()->user->getState('nazwisko');
		$returns[8] = Yii::app()->user->getState('imie');
		$returns[9] = substr(strval(Yii::app()->user->getState('pesel')),0,2);
		$returns[10] = substr(strval(Yii::app()->user->getState('pesel')),2,2);
		$year = substr(strval(Yii::app()->user->getState('pesel')),4,2);
		$returns[11] = intval($year)>=30 ? "19".$year : "20".$year;

		$returns[12] = Yii::app()->user->getState('nazwisko');
		$returns[13] = Yii::app()->user->getState('imie');

		$returns[15] = "P";
		$returns[14] = Yii::app()->user->getState('pesel');

		$returns[16] = "05";
		$returns[17] = "70";
		$returns[18] = "0";
		$returns[19] = "0";

		// actually used parameters
		$USPodstawaPrzedsiebiorcy = ParametryGry::getFloat('ZUS_PODSTAWA_US_PRZEDSIEBIORCY', 504.00);
		$UZPodstawaPrzedsiebiorcy = ParametryGry::getFloat('ZUS_PODSTAWA_UZ_PRZEDSIEBIORCY', 3004.48);
		$zdrowotne                = ParametryGry::getFloat('ZUS_UZ_PRZEDSIEBIORCY', 270.40);
		$chorobowe                = ParametryGry::getFloat('ZUS_CHOROB_PRZEDSIEBIORCY', 12.35);
		$rentowe                  = ParametryGry::getFloat('ZUS_RENTOW_PRZEDSIEBIORCY', 40.32);
		$emerytalne               = ParametryGry::getFloat('ZUS_EMERYT_PRZEDSIEBIORCY', 98.38);
		$wypadkowe                = ParametryGry::getFloat('ZUS_WYPADK_PRZEDSIEBIORCY', 9.73);

		$pensjaMinimalna     = ParametryGry::getFloat('PENSJA_MINIMALNA', 1680.00);
                $emeryturaPracodawca = ParametryGry::getFloat('ZUS_EMER_PRACODAWCA_PROC', 9.76);
                $emeryturaPracownik  = ParametryGry::getFloat('ZUS_EMER_PRACOWNIK_PROC', 9.76);
                $rentaPracodawca     = ParametryGry::getFloat('ZUS_RENT_PRACODAWCA_PROC', 6.50);
                $rentaPracownik      = ParametryGry::getFloat('ZUS_RENT_PRACOWNIK_PROC', 1.50);
                $wypadkowePracodawca = ParametryGry::getFloat('ZUS_WYP_PRACODAWCA_PROC', 1.93);
                $chorobowePracownik  = ParametryGry::getFloat('ZUS_CHOR_PRACOWNIK_PROC', 2.45);
                $zdrowotnePracownik  = ParametryGry::getFloat('ZUS_ZDROW_PRACOWNIK_PROC', 9.00);
                $funduszPracodawca   = ParametryGry::getFloat('ZUS_FP_PRACODAWCA_PROC', 2.45);
                $kosztUzyskPrzychodu = ParametryGry::getFloat('ZUS_KOSZT_UZYSKANIA_PRZYCHODU', 111.25);
		$podatekDochodowy    = ParametryGry::getFloat('PODATEK_DOCHODOWY', 0.18);

		$returns[20] = number_format($USPodstawaPrzedsiebiorcy,2,",","");
		$returns[21] = number_format($USPodstawaPrzedsiebiorcy,2,",","");
		$returns[22] = number_format($UZPodstawaPrzedsiebiorcy,2,",","");
		$returns[23] = number_format($zdrowotne,2,",","");
		$returns[24] = number_format($chorobowe,2,",","");
		$returns[25] = number_format($rentowe,2,",","");
		$returns[26] = number_format($emerytalne,2,",","");
		$returns[27] = number_format($wypadkowe,2,",","");
		$returns[28] = number_format($zdrowotne+$chorobowe+$rentowe+$emerytalne+$wypadkowe,2,",","");

		// pracownicy po kolei (max 3) - formularz uproszczony demonstracyjny
		$workers = PracownikFirmy::model()->with('idPracownika0')->findAll(array(
			'condition'=>'"idFirmy" = :idfirmy',
			'params'=>array(':idfirmy'=>$idFirmy)
		));

		$workcount = 0;
		foreach($workers as $worker)
		{
			$initput = 32+(19*$workcount);
			$returns[$initput  ] = $worker->idPracownika0->nazwisko;
			$returns[$initput+1] = $worker->idPracownika0->imie;
			$returns[$initput+3] = "P";
			$returns[$initput+2] = $worker->idPracownika0->pesel;
			$returns[$initput+4] = "01";
			$returns[$initput+5] = "10";
			$returns[$initput+6] = "0";
			$returns[$initput+7] = "0";

			$returns[$initput+8] = number_format($worker->wynagrodzenie,2,",","");
			$returns[$initput+9] = number_format($worker->wynagrodzenie,2,",","");

			$EPrac = $worker->wynagrodzenie*($emeryturaPracownik/100.0);
			$RPrac = $worker->wynagrodzenie*($rentaPracownik/100.0);
			$returns[$initput+14] = number_format($EPrac,2,",","");
			$returns[$initput+13] = number_format($RPrac,2,",","");

			$CPrac = $worker->wynagrodzenie*($chorobowePracownik/100.0);
			$returns[$initput+12] = number_format($CPrac,2,",","");

			$EPlat = $worker->wynagrodzenie*($emeryturaPracodawca/100.0);
			$RPlat = $worker->wynagrodzenie*($rentaPracodawca/100.0);
			$returns[$initput+17] = number_format($EPlat,2,",","");
			$returns[$initput+16] = number_format($RPlat,2,",","");

			$WPlat = $worker->wynagrodzenie*($wypadkowePracodawca/100.0);
			$returns[$initput+15] = number_format($WPlat,2,",","");

			$spolecznePracownika = $EPrac+$RPrac+$CPrac;
			$returns[$initput+10] = number_format((float)$worker->wynagrodzenie-$spolecznePracownika,2,",","");

			$ZPrac = ($worker->wynagrodzenie-$spolecznePracownika)*($zdrowotnePracownik/100.0);
			$returns[$initput+11] = number_format($ZPrac,2,",","");

			$returns[$initput+18] = number_format($EPrac+$RPrac+$CPrac+$EPlat+$RPlat+$WPlat+$ZPrac,2,",",""); // all

			$workcount++;
			if($workcount>=3) break;
		}
		// --- end pracownicy

		$returns[29] = date('dmY');

		// czy sa pracownicy
		/*
		$workers = PracownikFirmy::model()->findAll(array(
			'condition'=>'"idFirmy" = :idfirmy',
			'params'=>array(':idfirmy'=>$idFirmy)
		));
		*/
		echo json_encode($returns);
	}

	public function actionAjaxPit36()
	{
		$idFirmy = Yii::app()->user->getState("id_firmy");
                $idKlasy = Yii::app()->user->getState('id_klasy');
                $returns = array();

                // inicjalizacja pustych elementow
                for($i=0;$i<27;$i++) $returns[$i] = null;

		$returns[2] = "Pierwszy Urząd Skarbowy w Lublinie";
		$returns[5] = Yii::app()->user->getState('nazwisko');
		$returns[6] = Yii::app()->user->getState('imie');
		$returns[7] = substr(strval(Yii::app()->user->getState('pesel')),0,2);
		$returns[8] = substr(strval(Yii::app()->user->getState('pesel')),2,2);
		$year = substr(strval(Yii::app()->user->getState('pesel')),4,2);
		$returns[9] = intval($year)>=30 ? "19".$year : "20".$year;

		$returns[10] = "Polska";
		$returns[11] = "lubelskie";
		$returns[12] = "Lublin";
		$returns[13] = "Lublin";

		$biuro = Yii::app()->db->createCommand('
			SELECT b."adres",b."kodPocztowy" FROM "Budynek" b
			LEFT JOIN "Biuro" bi ON bi."idBudynku" = b."id"
			LEFT JOIN "BiuroFirmy" bf ON bf."idBiura" = bi."id"
			WHERE bf."idFirmy" = :idfirmy
		')->bindValue('idfirmy',$idFirmy)->queryRow();

		if($biuro)
		{
			$adresBiura = explode(" ", $biuro['adres']);
			$ulica = $adresBiura[count($adresBiura)-2];
			$numery = explode("/", $adresBiura[count($adresBiura)-1]);

			$returns[14] = $ulica; // biuro ulica
			if(count($numery)>=1)
			$returns[15] = $numery[0]; // biuro nr domu
			if(count($numery)>=2)
			$returns[16] = $numery[1]; // biuro nr mieszk
			$returns[17] = "Lublin";
			$returns[18] = $biuro['kodPocztowy'];
			$returns[19] = "Lublin";
		}

		$fv = Yii::app()->db->createCommand('
			SELECT "cenaNetto", "stawkaVat" FROM "Faktury" WHERE "czyKoszt"=0 AND "idFirmy" = :idfirmy
		')->bindValue('idfirmy',$idFirmy)->queryAll();

		$fk = Yii::app()->db->createCommand('
			SELECT "cenaNetto", "stawkaVat" FROM "Faktury" WHERE "czyKoszt"=1 AND "idFirmy" = :idfirmy
		')->bindValue('idfirmy',$idFirmy)->queryAll();

		$przychod = 0; // count invoices
		foreach($fv as $fvr)
			$przychod += (float)$fvr['cenaNetto']+$fvr['cenaNetto']*$fvr['stawkaVat'];
		$returns[20] = number_format((float)$przychod,2,",","");
		$returns[24] = number_format((float)$przychod,2,",","");
		$koszty = 0; // count cost inv
		foreach($fk as $fkr)
			$koszty += (float)$fvr['cenaNetto']+$fvr['cenaNetto']*$fvr['stawkaVat'];
		$returns[21] = number_format((float)$koszty,2,",","");
		$returns[25] = number_format((float)$koszty,2,",","");
		// dochod b-c
		$returns[22] = number_format((float)$przychod-$koszty,2,",","");
		$returns[26] = number_format((float)$przychod-$koszty,2,",","");
		// strata c-b
		$returns[23] = number_format((float)$koszty-$przychod,2,",","");
		// podatek
		$podatekDochodowy    = ParametryGry::getFloat('PODATEK_DOCHODOWY', 0.18);
		$returns[27] = number_format((float)$returns[26]*$podatekDochodowy,2,",","");

		echo json_encode($returns);
	}

	public function actionAjaxGetInfoStrings()
	{
		$messages = Akcja::model()->findAll(array(    //'"idRodzica" is null AND
			//'condition' => '"idLekcji" > 0',
			'order' => '"idLekcji" ASC'));
		$text = ParametryGry::model()->find('"nazwa" = \'TEXT_PO_LEKCJI\'');
		$textFirst = ParametryGry::model()->find('"nazwa" = \'TEXT_PO_PIERWSZYCH_LEKCJACH\'');
		$messageArray = array();
		$messageArray[-1] = Akcja::parseText($textFirst->wartosc);
		$messageArray[0] = Akcja::parseText($text->wartosc);

		$tematPo = ParametryGry::model()->find('"nazwa" = \'TEMAT_PO_LEKCJI\'');
		$topicArray = array();
		$topicArray[-1] = Akcja::parseText($tematPo->wartosc);
		$topicArray[0] = Akcja::parseText($tematPo->wartosc);

		//$i = 1;
		foreach ($messages as $msg)
		{
			$messageArray[$msg->id] = Akcja::parseText($msg->tresc);
			if(isset($msg->naglowek))
			{
				$topicArray[$msg->id] = Akcja::parseText($msg->naglowek);
			}
			//$i++;
		}

		// quick hack - debug lesson(-1) was breaking it
		$text2 = Akcja::model()->find(array('condition' => '"idRodzica" is null AND "idLekcji" = 1'));
		$messageArray[1] = Akcja::parseText($text2->tresc);
		$topicArray[1] = Akcja::parseText($text2->naglowek);

		echo json_encode(array('infoString'=>$messageArray, 'infoTopic'=>$topicArray));
	}

	public function actionAjaxGetTime()
	{
		//echo strtotime(Yii::app()->db->createCommand('select sysdate from dual')->queryScalar()) * 1000;
		echo number_format(microtime(true)*1000,0,'.','');
	}
}
